//
//  Parsing_XML_with_NSXMLParserAppDelegate.m
//  Parsing XML with NSXMLParser
//
//  Created by Vandad Nahavandipoor on 20/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

/* 1 */
//#import "Parsing_XML_with_NSXMLParserAppDelegate.h"
//
//@implementation Parsing_XML_with_NSXMLParserAppDelegate
//
//@synthesize window = _window;
//@synthesize xmlParser;
//
//- (BOOL)            application:(UIApplication *)application 
//  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
//  
//  NSString *xmlFilePath = [[NSBundle mainBundle] pathForResource:@"MyXML"
//                                  ofType:@"xml"];
//  
//  NSData *xml = [[NSData alloc] initWithContentsOfFile:xmlFilePath];
//  
//  self.xmlParser = [[NSXMLParser alloc] initWithData:xml];
//  self.xmlParser.delegate = self;
//  if ([self.xmlParser parse]){
//    NSLog(@"Plik XML został przetworzony.");
//  } else{
//    NSLog(@"Przetworzenie pliku XML nie powiodło się");
//  }
//  
//  self.window = [[UIWindow alloc] initWithFrame:
//                 [[UIScreen mainScreen] bounds]];
//  
//  self.window.backgroundColor = [UIColor whiteColor];
//  [self.window makeKeyAndVisible];
//  return YES;
//}
//
//@end

/* 2 */
#import "Parsing_XML_with_NSXMLParserAppDelegate.h"
#import "XMLElement.h"

@implementation Parsing_XML_with_NSXMLParserAppDelegate

@synthesize window = _window;
@synthesize xmlParser;
@synthesize rootElement;
@synthesize currentElementPointer;

- (void)parserDidStartDocument:(NSXMLParser *)parser{
  self.rootElement = nil;
  self.currentElementPointer = nil;
}

- (void)parserDidEndDocument:(NSXMLParser *)parser{
  self.currentElementPointer = nil;
}

- (void)        parser:(NSXMLParser *)parser 
       didStartElement:(NSString *)elementName 
          namespaceURI:(NSString *)namespaceURI
         qualifiedName:(NSString *)qName
            attributes:(NSDictionary *)attributeDict{
  
  if (self.rootElement == nil){
    /* Nie ma elementu głównego. Tworzymy go więc i wskazujemy. */
    self.rootElement = [[XMLElement alloc] init];
    self.currentElementPointer = self.rootElement;
  } else {
    /* Element główny już jest. Tworzymy nowy element i dodajemy jako
      jeden z podelementów bieżącego elementu. */
    XMLElement *newElement = [[XMLElement alloc] init];
    newElement.parent = self.currentElementPointer;
    [self.currentElementPointer.subElements addObject:newElement];
    self.currentElementPointer = newElement;
  }

  self.currentElementPointer.name = elementName;
  self.currentElementPointer.attributes = attributeDict;
  
}

- (void)        parser:(NSXMLParser *)parser
         didEndElement:(NSString *)elementName
          namespaceURI:(NSString *)namespaceURI
         qualifiedName:(NSString *)qName{
  
  self.currentElementPointer = self.currentElementPointer.parent;
  
}

- (void)        parser:(NSXMLParser *)parser 
       foundCharacters:(NSString *)string{
  
  if ([self.currentElementPointer.text length] > 0){
    self.currentElementPointer.text = 
      [self.currentElementPointer.text stringByAppendingString:string];
  } else {
    self.currentElementPointer.text = string;
  }
  
}

- (BOOL)            application:(UIApplication *)application 
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  NSString *xmlFilePath = [[NSBundle mainBundle] pathForResource:@"MyXML"
                                                          ofType:@"xml"];
  
  NSData *xml = [[NSData alloc] initWithContentsOfFile:xmlFilePath];
  
  self.xmlParser = [[NSXMLParser alloc] initWithData:xml];
  self.xmlParser.delegate = self;
  if ([self.xmlParser parse]){
    NSLog(@"Plik XML został przetworzony.");
    
    /* self.rootElement jest teraz elementem głównym w dokumencie XML. */
    XMLElement *element = [self.rootElement.subElements objectAtIndex:1];
    NSLog(@"%@", element.subElements);
    
  } else{
    NSLog(@"Przetworzenie pliku XML nie powiodło się.");
  }
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

@end